/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.BitSet;

public class ItemLayerPixels {
    private BitSet[] rows = new BitSet[0];
    private int width = 0;

    private static int gcd(int a, int b) {
        while (b > 0) {
            int orig = b;
            b = a % b;
            a = orig;
        }
        return a;
    }

    private static int lcm(int a, int b) {
        return a * (b / ItemLayerPixels.gcd(a, b));
    }

    private void ensureSizeFits(int checkWidth, int checkHeight) {
        int oldHeight = this.rows.length;
        if (oldHeight == 0 || this.width == 0) {
            this.rows = new BitSet[checkHeight];
            this.width = checkWidth;
        } else {
            if (this.width % checkWidth != 0) {
                int newWidth = ItemLayerPixels.lcm(this.width, checkWidth);
                int xSpacing = newWidth / this.width;
                for (int y = 0; y < oldHeight; ++y) {
                    BitSet oldRow = this.rows[y];
                    if (oldRow == null) continue;
                    BitSet newRow = this.rows[y] = new BitSet(newWidth);
                    for (int i : oldRow.stream().toArray()) {
                        int start = i * xSpacing;
                        newRow.set(start, start + xSpacing);
                    }
                }
                this.width = newWidth;
            }
            if (oldHeight % checkHeight != 0) {
                int newHeight = ItemLayerPixels.lcm(oldHeight, checkHeight);
                int ySpacing = newHeight / oldHeight;
                BitSet[] newRows = new BitSet[newHeight];
                for (int y = 0; y < oldHeight; ++y) {
                    BitSet oldRow = this.rows[y];
                    if (oldRow != null) {
                        int start = y * ySpacing;
                        newRows[start] = oldRow;
                        for (int i = 1; i < ySpacing; ++i) {
                            newRows[start + i] = (BitSet)oldRow.clone();
                        }
                        newRows[y * ySpacing] = oldRow;
                    }
                    this.rows = newRows;
                }
            }
        }
    }

    private boolean getInternal(int x, int y) {
        BitSet set;
        if (y <= this.rows.length && (set = this.rows[y]) != null) {
            return set.get(x);
        }
        return false;
    }

    public boolean get(int x, int y, int width, int height) {
        if (this.rows.length == 0 || this.width == 0) {
            return false;
        }
        if ((x *= this.width) % width != 0) {
            return false;
        }
        if ((y *= this.rows.length) % height != 0) {
            return false;
        }
        return this.getInternal(x / width, y / height);
    }

    public void set(int x, int y, int width, int height) {
        if (x < 0 || x >= width) {
            throw new IllegalArgumentException("Parameter X must be between 0 and width");
        }
        if (y < 0 || y >= height) {
            throw new IllegalArgumentException("Parameter Y must be between 0 and height");
        }
        this.ensureSizeFits(width, height);
        int xSize = this.width / width;
        int ySize = this.rows.length / height;
        x *= xSize;
        y *= ySize;
        for (int dy = 0; dy < ySize; ++dy) {
            BitSet set = this.rows[y + dy];
            if (set == null) {
                BitSet bitSet = new BitSet(this.width);
                this.rows[y + dy] = bitSet;
                set = bitSet;
            }
            set.set(x, x + xSize);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ItemLayerPixels:\n");
        for (int y = 0; y < this.rows.length; ++y) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int x = 0; x < this.width; ++x) {
                rowBuilder.append(this.getInternal(x, y) ? (char)'X' : '_');
            }
            builder.append((CharSequence)rowBuilder).append('\n');
        }
        return builder.toString();
    }
}

